function [SS_stoch] = make_SS_stoch_nsytvar(SS_eq_cell, nves, par, nsytvar)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%This script stochastically computes a steady state matrix (nsyt x nves)
%for a model with variable syt numbers 

%Input:
%SS_eq_cell - Steady state distribution of vesicle states output function: steady_state_newmethod_mutant
%nves - number of vesicles
%par - model parameters
%nsytvar - number of syts for each vesicle

%output
%SS_stoch - steady state matrix for nsyt x nves

maxCross = par(9);
%nSyts = par(8);
%n_WT= par(11);
n_mut = 0;



%needs to be repeated for all no of syts
for n_WT = 1:max(nsytvar)
    if maxCross > n_WT
    maxCross = n_WT;
    else
        maxCross = par(9);
    end
    [~, states{n_WT}] = indCal_all_mutant(n_WT, n_mut, maxCross);
    cum_SS{n_WT} = cumsum(SS_eq_cell{n_WT});
end

p_draw = rand(1,nves);

SS_stoch = zeros(50, nves);


for k = 1:nves
    p_ves = p_draw(k);
    nsyt_ves = nsytvar(k);
    
    SS_ind = find(p_ves<=cum_SS{nsyt_ves}, 1, 'first');
    
    ves_state = states{nsyt_ves}(SS_ind,:);
    
    SS_stoch(1:ves_state(1),k) = 11;
    SS_stoch((ves_state(1)+1):(ves_state(1)+ves_state(3)),k) = 1;
    SS_stoch((ves_state(1)+ves_state(3)+1):(ves_state(1) + ves_state(3)+ves_state(5)),k) = 10;

   
end
    